////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  OBPDFViewController.h
//    Controller component in MVC for PDF generation support.
//
//  Copyright (C) 2010-2011 Acclivity Group LLC, all rights reserved.
//
//  Change History (most recent first):
//
//	06/26/11  K.L.S.  Added ability to name print job.
//	09/16/10  K.L.S.  Created file.
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#import <Cocoa/Cocoa.h>

@class OBPDFView;
@class OBPDFViewModel;

@interface OBPDFViewController : NSObject
{
@private
	NSString* outputTitle;
	OBPDFView* pdfView;
	NSImage* pdfImage;
	OBPDFViewModel* pdfViewModel;
	NSRect pageFrame;
	BOOL isLandscaped;
	BOOL dontShowPrintPanelDuringPrintPDF;
}

-(instancetype)initWithPaperFrame:(NSRect)paperFrame;
-(instancetype)initWithPaperFrame:(NSRect)paperFrame pageFrame:(NSRect)pageFrame;
-(instancetype)initWithPaperFrame:(NSRect)paperFrame pageFrame:(NSRect)pageFrame landscaped:(BOOL)landscped NS_DESIGNATED_INITIALIZER;

-(void)setClipRect:(NSRect)clipRect;
-(void)setPaperFrame:(NSRect)paperFrame;
-(void)setLandscaped:(BOOL)landscaped;
-(void)setScalingDisabled:(BOOL)disableScaling;

@property (nonatomic, copy) NSString *outputTitle;

@property (nonatomic, readonly) BOOL showPrintPanel;
-(NSError*)outputPDF:(NSString*)outputPath;
@property (nonatomic, readonly, copy) NSError *printPDF;
@property (nonatomic, readonly, copy) NSError *previewPDF;

//
-(void)beginPage;

@property (nonatomic, readonly) NSUInteger pageCount;
@property (nonatomic) NSRect pageFrame;

// Draw methods
-(void)drawOvalInRect:(NSRect)enclosingRect withFrameColor:(NSColor*)frameColor fillColor:(NSColor*)fillColor lineWidth:(float)lineWidth
		   dashedLine:(BOOL)dashedLine;
-(void)drawRectangle:(NSRect)rectangle withFrameColor:(NSColor*)frameColor fillColor:(NSColor*)fillColor lineWidth:(float)lineWidth
			  radius:(float)radius  dashedLine:(BOOL)dashedLine;
-(void)drawText:(NSString*)text withinFrame:(NSRect)frame withTextAttributes:(NSDictionary*)textAttributes;
-(void)drawPolygonWithPoints:(NSData*)points withLineColor:(NSColor*)lineColor fillColor:(NSColor*)fillColor lineWidth:(float)lineWidth
				  dashedLine:(BOOL)dashedLine;
-(void)drawImage:(NSImage*)image inDestinationRect:(NSRect)rect;
-(void)drawImage:(NSImage*)image inDestinationRect:(NSRect)rect withClipRect:(NSRect)clipRect;


@end
